package centralSystemOld;

/**
 * {@link IPostCounter} interface represents 
 * any generic counter in a post office
 * 
 * @author simone
 *
 */
public interface IPostCounter {

	/**
	 * Notifies that this counter has handled
	 * the current client, with a consequent decrease
	 * in awaiting clients number (for that specific queue).
	 * 
	 * @return: an int representing the postal service this counter 
	 * is ready to handle. Some implementation of {@link IPostCounter}
	 * may work at run-time on more than one queue
	 */
	public int nextService();
}
